import SwiftUI

struct ContentView: View {
    var body: some View {
        // 이 뷰는 실제로 표시되지 않습니다
        // 앱은 백그라운드에서 실행되며 메뉴바에만 아이콘이 나타납니다
        VStack {
            Text("입력 언어 알림 앱")
                .font(.title)
                .padding()
            
            Text("이 창은 곧 사라집니다.")
                .font(.caption)
                .foregroundColor(.gray)
                .padding(.bottom)
            
            Text("앱이 백그라운드에서 실행됩니다.")
                .font(.caption)
                .foregroundColor(.gray)
        }
        .frame(width: 300, height: 200)
        .onAppear {
            // 1초 후에 이 창을 닫습니다
            DispatchQueue.main.asyncAfter(deadline: .now() + 1.0) {
                if let window = NSApplication.shared.windows.first {
                    window.close()
                }
            }
        }
    }
}

#Preview {
    ContentView()
}
