# InputLanguageNotifier

macOS에서 **입력 소스(한/영 전환)**이 바뀔 때 화면 중앙에 간단한 알림을 띄워주는 작은 유틸리티입니다.  
(메뉴바 아이콘으로 현재 입력 상태도 확인할 수 있습니다.)

---

## 📌 개발 목적

GPT 기반 앱(대부분 한글 입력)과 개발 도구·터미널(영문 입력)을 오가다 보면,  
앱 전환 시 입력 소스가 기대와 다르게 설정되어 불편한 경우가 있습니다.

macOS 설정에서 **“Automatically switch to a document’s input source”** 옵션을 켜면,  
앱 전환 시 그 앱의 기본 입력 소스로 자동 전환되므로 대부분 문제는 해결됩니다.  
하지만 이때 **“언어가 전환되었다”**는 사실을 직관적으로 알려주는 기능은 macOS에 없습니다.

앱스토어에는 `isHUD`(유료, 1,100원)라는 유사 앱이 존재하나,  
마지막 업데이트가 6년 전(Mojave 시절)이고 최신 macOS 지원 여부가 불확실합니다.  
따라서 유사한 대체 프로그램이 사실상 없는 상황에서,  
**ChatGPT와 Claude를 활용한 바이브 코딩 방식**으로 직접 개발했습니다.  

- Claude → 초기 프로그램 코드 작성  
- ChatGPT → 이후 코드 개선 및 안정화  
- 결과적으로 **사용자 개입 없이 100% LLM으로만 개발**된 앱입니다.

---

## ✨ 주요 기능

- 앱 전환으로 입력 소스가 바뀔 때 HUD(알림 박스) 표시
- 같은 앱 안에서 입력 소스를 수동으로 바꾸더라도 HUD 표시
- HUD는 현재 사용하는 **디스플레이 중앙**에 표시
- 텍스트 길이에 맞춰 박스 크기와 글꼴 크기 자동 조정
- 메뉴바 아이콘:
  - 🇰🇷 한글 → **`한`**
  - 🇺🇸 영문 → **`A`**

---

## 🖥️ 시스템 요구사항

- macOS 12 (Monterey) 이상 권장  
- Intel, Apple Silicon 모두 지원  

---

## 📦 설치 및 실행

1. [Releases](#) 페이지에서 최신 `InputLanguageNotifier-<버전>.zip` 다운로드
2. 압축 해제 후 `InputLanguageNotifier.app`을 `/Applications` 폴더로 이동
3. 처음 실행 시: **우클릭 → 열기** 선택 (서명/공증이 없기 때문에 한 번만 필요)
4. 실행 후 메뉴바에 `A` 또는 `한` 아이콘이 표시됨

> 메뉴바 아이콘 → “종료” 메뉴로 앱을 종료할 수 있습니다.

---

## ⚠️ 알려진 제한 사항

- **서명/공증 없음**: Finder에서 더블클릭 실행이 차단될 수 있습니다. (우클릭 → 열기 필요)
- **자동 업데이트 없음**: 새 버전은 직접 다운로드/설치해야 합니다.
- 다국어 입력 소스(일본어, 중국어 등)는 현재 `첫 글자`로 배지 표시됩니다.

---

## 📖 개발 방식

- **아이디어 및 초기 코드 생성**: Claude
- **코드 개선, 크래시 디버깅, 안정화**: ChatGPT
- **결과**: 사용자 개입 없이 100% LLM 코딩으로 완성

---

## 📜 라이선스

MIT License.  
자유롭게 사용, 수정, 재배포 가능합니다.

---

## 🙏 크레딧

- Apple macOS Text Input Source API (`TISCopyCurrentKeyboardInputSource`, `kTISNotifySelectedKeyboardInputSourceChanged`)
- ChatGPT & Claude 협업 바이브 코딩